AdvancedMaintenance = {}
AdvancedMaintenance.MOD_NAME = g_currentModName
ShowMessage = false
MessageCounter = 0
print("DEBUG AdvancedMaintenance SCRIPT LOADED AGAIN")

function AdvancedMaintenance.prerequisitesPresent(specializations)
    return true
end

function AdvancedMaintenance.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdate", AdvancedMaintenance)
    --SpecializationUtil.registerEventListener(vehicleType, "onDrawUIInfo", AdvancedMaintenance)
end

function AdvancedMaintenance.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "getCanMotorRun", AdvancedMaintenance.getCanMotorRun);
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "getMotorNotAllowedWarning", AdvancedMaintenance.getMotorNotAllowedWarning);
end



function AdvancedMaintenance:getCanMotorRun(superFunc)
    local spec = self.spec_motorized
    local IsDead = AdvancedMaintenance:CheckDamage(self)

    for _, fillUnitIndex in ipairs(spec.propellantFillUnitIndices) do
        if self:getFillUnitFillLevel(fillUnitIndex) == 0 then
            return false
        end
    end

    if not spec.motor:getCanMotorRun() then
        return false
    end

    if IsDead then
        return false
    end

    return true
end


function AdvancedMaintenance:getMotorNotAllowedWarning()
    local spec = self.spec_motorized

    for _, fillUnit in pairs(spec.propellantFillUnitIndices) do
        if self:getFillUnitFillLevel(fillUnit) == 0 then
            return spec.consumersEmptyWarning
        end
    end

    local IsDead = AdvancedMaintenance:CheckDamage(spec)
    if IsDead then
        return g_i18n.modEnvironments[AdvancedMaintenance.MOD_NAME].texts.AdvancedMaintenance_DEAD_ENGINE
    end

    local canMotorRun, reason = spec.motor:getCanMotorRun()
    if not canMotorRun then
        if reason == VehicleMotor.REASON_CLUTCH_NOT_ENGAGED then
            return spec.clutchNoEngagedWarning
        end
    end

    return nil
end





function AdvancedMaintenance:onUpdate()
    if AdvancedMaintenance:CheckDamage(self) then
        AdvancedMaintenance:StopAI(self)
    end
end




function AdvancedMaintenance:onDrawUIInfo()
    local damageValue = 1

    local vehicle = self.vehicle
    local vehicles = self.rootVehicle.childVehicles

    local SpeedMeterDisplay = SpeedMeterDisplay.new()

    local posX, posY = SpeedMeterDisplay:getPosition()
end



function AdvancedMaintenance:CheckDamage(self)
    local VehicleDamage = self:getDamageAmount()
    local VehicleLoadPrecentage = self:getMotorLoadPercentage()
    local VehicleOperatingTime = self:getOperatingTime()

    --print("DEBUG AdvancedMaintenance VehicleDamage -->" .. VehicleDamage)
    --print("DEBUG AdvancedMaintenance VehicleLoadPrecentage -->" .. VehicleLoadPrecentage)
    --print("DEBUG AdvancedMaintenance VehicleOperatingTime -->" .. VehicleOperatingTime)

    if VehicleDamage == 1 then -- If damage is 100% then disable the engine
        return true
    end

    if VehicleDamage > 0.28571428571429 then
        local Chance = 50000 / (VehicleDamage * 10 * VehicleOperatingTime / 900000000) --Credits to @BRZMonster

        --print("DEBUG AdvancedMaintenance VehicleDamage -->" .. Chance)

        if Chance > 0 then
            local RandomNumber1 = math.random(Chance)
            local RandomNumber2 = math.random(Chance)
    
            if Chance < 100 then
                RandomNumber1 = 0
                RandomNumber2 = 0
            end
    
            --print("DEBUG AdvancedMaintenance DAMAGE IS MORE THEN 50% [" .. Chance .. "] [" .. RandomNumber1 .. "] [" .. RandomNumber2 .. "]")
    
            if RandomNumber1 == RandomNumber2 then
                --g_currentMission:showBlinkingWarning("engine malfunction", 2000)
                return true
            end
        end
    end
    return false
end

function AdvancedMaintenance:StopAI(self)
    local rootVehicle = self.rootVehicle
    if rootVehicle ~= nil and rootVehicle:getIsAIActive() then
        rootVehicle:stopCurrentAIJob(AIMessageErrorVehicleBroken.new())
    end
end

addModEventListener(AdvancedMaintenance)